/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.platform;

import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.platform.Env;
import net.createmod.catnip.platform.Loader;
import net.createmod.catnip.platform.services.PlatformHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class FabricPlatformHelper
implements PlatformHelper {
    @Override
    public Loader getLoader() {
        return Loader.FABRIC;
    }

    @Override
    public Env getEnv() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? Env.CLIENT : Env.SERVER;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public List<String> getLoadedMods() {
        ArrayList<String> modIds = new ArrayList<String>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            modIds.add(mod.getMetadata().getId());
        }
        return modIds;
    }

    @Override
    public String getModDisplayName(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(mod -> mod.getMetadata().getName()).orElse(ConfigScreen.toHumanReadable(modId));
    }

    @Override
    public void executeOnClientOnly(Supplier<Runnable> toRun) {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, toRun);
    }

    @Override
    public void executeOnServerOnly(Supplier<Runnable> toRun) {
        EnvExecutor.runWhenOn((EnvType)EnvType.SERVER, toRun);
    }
}

